*** rt-U_s.do
*** v1.1
clear all
set more off
set type double
set matsize 1000

*** create rt vintages
insheet using UEMPLT5_2_Vintages_Starting_1964_02_06.txt, clear
gen int mdate = mofd(date(observation_date,"YMD"))
tsset mdate, m
order mdate
drop observation_date

drop uemplt5_20060508

** drop the day from the release date
unab rellist: uemplt5_*
local rdatelist: subinstr local rellist "uemplt5_" "", all
macro drop _rellist
foreach rdate of local rdatelist {
    local yr = string(int(`rdate'/10000),"%04.0f")
    local mon = string(int(`rdate'/100)-int(`rdate'/10000)*100,"%02.0f")
*    local rmdate = `yr'`mon'
    local rmdate = ym(`yr',`mon')
    rename uemplt5_`rdate' U_s_`rmdate'
}

compress
save rt-U_s.dta, replace
